import pandas as pd
import numpy as np
import pickle
from decision_company import read_csv_file, fetch_column, logical_and, logical_or, create_dataframe, concatenate_objects, reset_index, search_where, extract_unique_values, update_dict, assert_series


# Load the dataset
atp_tennis = read_csv_file("atp_tennis.csv")

# Find Federer matches
federer_matches = atp_tennis[logical_or(assert_series(atp_tennis['Player_1'], 'Federer R.', 'equality'), assert_series(atp_tennis['Player_2'], 'Federer R.', 'equality'))]

# Get Federer opponents
federer_opponents = extract_unique_values(search_where(fetch_column(federer_matches, 'Player_1'), assert_series(federer_matches['Player_1'], 'Federer R.', 'inequality'), federer_matches['Player_2']))

# Retrieve unique surface types
surface_types = extract_unique_values(fetch_column(atp_tennis, 'Surface'))

def calculate_performance(player, opponent, data):
    player_matches = data[logical_or(logical_and(assert_series(data['Player_1'], player, 'equality'), assert_series(data['Player_2'], opponent, 'equality')), logical_and(assert_series(data['Player_1'], opponent, 'equality'), assert_series(data['Player_2'], player, 'equality')))]
    total_matches = len(player_matches)
    wins = len(player_matches[assert_series(player_matches['Winner'], player, 'equality')])
    win_rate = wins / total_matches if total_matches > 0 else 0

    h2h_record = wins / total_matches if total_matches > 0 else 0

    surface_performance = {}
    for surface in surface_types:
        player_surface_matches = player_matches[assert_series(player_matches['Surface'], surface, 'equality')]
        player_surface_wins = len(player_surface_matches[assert_series(player_surface_matches['Winner'], player, 'equality')])
        surface_performance[surface] = player_surface_wins / player_surface_matches.shape[0] if player_surface_matches.shape[0] > 0 else 0

    return win_rate, h2h_record, surface_performance

# Initialize an empty dataframe for storing the results
columns = ['Player', 'Opponent', 'Win Rate', 'Head-to-Head'] + [f'{surface} Surface Performance' for surface in surface_types]
player_stats = create_dataframe(data=[], columns=columns)

# Loop through Federer's opponents
for opponent in federer_opponents:
    # Calculate win rate, head-to-head record, and surface performance for Raonic M. against each opponent
    win_rate, h2h_record, surface_performance = calculate_performance('Raonic M.', opponent, atp_tennis)

    # Append the results to the dataframe
    row_data = {'Player': 'Raonic M.', 'Opponent': opponent, 'Win Rate': win_rate, 'Head-to-Head': h2h_record}
    update_dict(row_data, {f'{surface} Surface Performance': surface_performance[surface] for surface in surface_types})
    player_stats = concatenate_objects(player_stats, create_dataframe(row_data, index=[0]))

print(player_stats)
pickle.dump(player_stats,open("./ref_result/player_stats.pkl","wb"))